define(['angular', 'app', 'formatter', 'BaseCRUDService'], function (angular, app) {
	"use strict";
	app.service('CollectionCRUDMockService', function ($rootScope, $http, $q, $parse, $filter, BaseCRUDMockService, formatter) {

		//expected use
		//fetch > save/delete
		//list will not be initialized properly if a save is done without a fetch

		//Constructor
		var CollectionCRUDService = function(config) {

			var that = this;

			that.config = config;

			that.BaseCRUDService = new BaseCRUDMockService(config);

			that.dataPointers = {
				list: null,
				filters: null,
				link: null
			};

			$rootScope.$on("$stateChangeSuccess", function(event, toState, toParams, fromState, fromParams){
				if(fromState.name === "" || toState.data.moduleName !== fromState.data.moduleName) {
					that.reset();
				}
			});	

		};

		//Methods
		CollectionCRUDService.prototype = {};

		CollectionCRUDService.prototype.transformResponse = function(item) {	
			return this.config.object.responseTransform ? this.config.object.responseTransform(item) : item;
		};

		CollectionCRUDService.prototype._onRequestComplete = function (promise) {
			var that = this;
			var defer = $q.defer();

			var request = promise.then(function(response){
				if(response['object-type'] === that.config.collection.objectType) {
					if (response[that.config.collection.name]) {
						response[that.config.collection.name].forEach(function (item) {
							item = that.transformResponse(item);
						});
                        response.size = response[that.config.collection.name].length;
					} else {
						response[that.config.collection.name] = [];
                        response.size = 0
					}
				} else if(response) {
					response = that.transformResponse(response);
                    response.size = response[that.config.collection.name].length;
				}
				defer.resolve(response);
			},function(){
				defer.reject(error);
			});

			return defer.promise;
		};

		CollectionCRUDService.prototype._deleteFromLocalList = function(item){
			var list = this.dataPointers.list;
			var listLength = list ? list.length : 0;
			var expectedId = this.idGetter(item);
			if(expectedId) {
				var expression = {};
				expression[this.config.object.uidKey] = '!' + expectedId;
				this.dataPointers.list = $filter("filter")(list, expression, true);
			}
		}

		CollectionCRUDService.prototype.idGetter = function(item){
			return this.BaseCRUDService.idGetter(item);
		};

		CollectionCRUDService.prototype.localGetById = function(id) {
			var that = this;
			var list = that.dataPointers.list;
			var listLength = list ? that.dataPointers.list.length : 0;
			for(var i = 0; i < listLength; i++) {
				if(angular.equals(id, that.idGetter(list[i]))){
					return angular.copy(list[i]);
				}
			}			
		};

		CollectionCRUDService.prototype.createEmpty = function() {
			return this.BaseCRUDService.createEmpty();
		};


		CollectionCRUDService.prototype.fetch = function (queryParams) {
			var that = this;
			var requestPromise = that._onRequestComplete(that.BaseCRUDService.fetch(queryParams));
			requestPromise.then(function (response) {
				that.dataPointers.filters = queryParams;
				that.dataPointers.list = that.config.collection.filter ? that.config.collection.filter(response[that.config.collection.name], that.dataPointers.filters) : response[that.config.collection.name];
				that.dataPointers.list = that.dataPointers.list ? that.dataPointers.list.sort(that.config.collection.sortComparator): [];
				that.dataPointers.link = response.link;
			});
			return requestPromise;
		};

		CollectionCRUDService.prototype.save = function (item) {
			var that = this;
			var requestPromise = that._onRequestComplete(that.BaseCRUDService.save(item));

			requestPromise.then(function (responseItem) {
				if(that.dataPointers.list) {
					that._deleteFromLocalList(item);
					var scopedList = angular.copy(that.dataPointers.list);
					scopedList.push(responseItem);
					scopedList = that.config.collection.filter ? that.config.collection.filter(scopedList, that.dataPointers.filters) : scopedList;
					scopedList = scopedList.sort(that.config.collection.sortComparator);
					that.dataPointers.list = scopedList;
				}
			});
			return requestPromise;
		};

		CollectionCRUDService.prototype.delete = function (item) {
			var that = this;

			var requestPromise = that._onRequestComplete(that.BaseCRUDService.delete(item));
			requestPromise.then(function (response) {
				that._deleteFromLocalList(item);
			});
			return requestPromise;
		};

		CollectionCRUDService.prototype.reset = function() {
			this.dataPointers.list = null;
			this.dataPointers.filters = null;
			this.dataPointers.link = null;
		};

		return CollectionCRUDService;
	});
});